/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.v.VesuvanShapeShifterFaceUpCopyApplier;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.util.functions.CopyApplier;

class VesuvanShapeshifterEffect
extends OneShotEffect {
    VesuvanShapeshifterEffect() {
        super(Outcome.Copy);
        this.staticText = "have {this} become a copy of a creature, except it has this ability";
    }

    private VesuvanShapeshifterEffect(VesuvanShapeshifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public VesuvanShapeshifterEffect copy() {
        return new VesuvanShapeshifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent copyToCreature = game.getPermanent(source.getSourceId());
        if (copyToCreature != null) {
            Permanent copyFromCreature;
            TargetPermanent target = new TargetPermanent(0, 1, (FilterPermanent)StaticFilters.FILTER_ANOTHER_CREATURE, true);
            if (controller != null && controller.chooseTarget(Outcome.BecomeCreature, (Target)target, source, game) && !target.getTargets().isEmpty() && (copyFromCreature = game.getPermanentOrLKIBattlefield(target.getFirstTarget())) != null) {
                game.copyPermanent(Duration.Custom, copyFromCreature, copyToCreature.getId(), source, (CopyApplier)new VesuvanShapeShifterFaceUpCopyApplier());
                source.getTargets().clear();
                game.processAction();
                return true;
            }
        }
        return false;
    }
}

