/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VesuvanShapeshifterFaceDownEffect
extends OneShotEffect {
    VesuvanShapeshifterFaceDownEffect() {
        super(Outcome.Copy);
        this.staticText = "turn this creature face down";
    }

    private VesuvanShapeshifterFaceDownEffect(VesuvanShapeshifterFaceDownEffect effect) {
        super((OneShotEffect)effect);
    }

    public VesuvanShapeshifterFaceDownEffect copy() {
        return new VesuvanShapeshifterFaceDownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller == null || permanent == null) {
            return false;
        }
        permanent.removeAllAbilities(source.getSourceId(), game);
        for (Effect effect : game.getState().getContinuousEffects().getLayeredEffects(game)) {
            CopyEffect copyEffect;
            if (!(effect instanceof CopyEffect) || !(copyEffect = (CopyEffect)effect).getSourceId().equals(permanent.getId())) continue;
            copyEffect.discard();
        }
        permanent.turnFaceDown(source, game, source.getControllerId());
        permanent.setManifested(false);
        permanent.setDisguised(false);
        permanent.setCloaked(false);
        permanent.setMorphed(true);
        return permanent.isFaceDown(game);
    }
}

