/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseACardNameEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class VexingArcanixEffect
extends OneShotEffect {
    VexingArcanixEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target player chooses a card name, then reveals the top card of their library. If that card has the chosen name, the player puts it into their hand. Otherwise, the player puts it into their graveyard and {this} deals 2 damage to them";
    }

    private VexingArcanixEffect(VexingArcanixEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (sourceObject == null || player == null) {
            return false;
        }
        String cardName = ChooseACardNameEffect.TypeOfName.ALL.getChoice(player, game, source, false);
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return true;
        }
        CardsImpl cards = new CardsImpl(card);
        player.revealCards(sourceObject.getIdName(), (Cards)cards, game);
        if (CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) {
            player.moveCards((Cards)cards, Zone.HAND, source, game);
        } else {
            player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
            player.damage(2, source.getSourceId(), source, game);
        }
        return true;
    }

    public VexingArcanixEffect copy() {
        return new VexingArcanixEffect(this);
    }
}

