/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VexingDevilEffect
extends OneShotEffect {
    VexingDevilEffect() {
        super(Outcome.Neutral);
        this.staticText = "any opponent may have it deal 4 damage to them. If a player does, sacrifice {this}";
    }

    private VexingDevilEffect(VexingDevilEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            for (UUID opponentUuid : game.getOpponents(source.getControllerId())) {
                Player opponent = game.getPlayer(opponentUuid);
                if (opponent == null || !opponent.chooseUse(Outcome.LoseLife, "Make " + permanent.getLogName() + " deal 4 damage to you?", source, game)) continue;
                game.informPlayers(opponent.getLogName() + " has chosen to receive 4 damage from " + permanent.getLogName());
                opponent.damage(4, permanent.getId(), source, game);
                permanent.sacrifice(source, game);
                return true;
            }
            game.informPlayers("4 damage wasn't dealt so " + permanent.getLogName() + " won't be sacrificed.");
            return true;
        }
        return false;
    }

    public VexingDevilEffect copy() {
        return new VexingDevilEffect(this);
    }
}

