/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class VialSmasherTheFierceEffect
extends OneShotEffect {
    VialSmasherTheFierceEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} choose an opponent at random. {this} deals damage equal to that spell's mana value to that player or a planeswalker that player controls";
    }

    private VialSmasherTheFierceEffect(VialSmasherTheFierceEffect effect) {
        super((OneShotEffect)effect);
    }

    public VialSmasherTheFierceEffect copy() {
        return new VialSmasherTheFierceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int damage = (Integer)this.getValue("VialSmasherTheFierceCMC");
            if (damage > 0) {
                List opponents = game.getOpponents(source.getControllerId()).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).filter(o -> !o.hasLost()).filter(o -> !o.hasLeft()).collect(Collectors.toList());
                if (opponents.isEmpty()) {
                    return false;
                }
                Collections.shuffle(opponents);
                Player opponent = (Player)opponents.get(0);
                game.informPlayers(opponent.getLogName() + " was chosen at random.");
                if (!game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterPlaneswalkerPermanent(), opponent.getId(), game).isEmpty() && controller.chooseUse(Outcome.Damage, "Redirect to a planeswalker controlled by " + opponent.getLogName() + "?", source, game)) {
                    Permanent permanent;
                    FilterPlaneswalkerPermanent filter = new FilterPlaneswalkerPermanent("a planeswalker controlled by " + opponent.getLogName());
                    filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
                    TargetPermanent target = new TargetPermanent(1, 1, (FilterPermanent)filter, false);
                    if (target.choose(Outcome.Damage, controller.getId(), source.getSourceId(), source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
                        return permanent.damage(damage, source.getSourceId(), source, game, false, true) > 0;
                    }
                }
                opponent.damage(damage, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

