/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ViashinoHereticEffect
extends OneShotEffect {
    public ViashinoHereticEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact. {this} deals damage to that artifact's controller equal to the artifact's mana value";
    }

    private ViashinoHereticEffect(ViashinoHereticEffect effect) {
        super((OneShotEffect)effect);
    }

    public ViashinoHereticEffect copy() {
        return new ViashinoHereticEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            int couvertedManaCost = permanent.getManaValue();
            Player player = game.getPlayer(permanent.getControllerId());
            permanent.destroy(source, game, false);
            if (player != null) {
                player.damage(couvertedManaCost, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

