/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ManaWasSpentCondition;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VigorMortisReplacementEffect
extends ReplacementEffectImpl {
    private static final Condition condition = ManaWasSpentCondition.GREEN;

    VigorMortisReplacementEffect() {
        super(Duration.EndOfStep, Outcome.BoostCreature);
    }

    private VigorMortisReplacementEffect(VigorMortisReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getTargetId().equals(this.getTargetPointer().getFirst(game, source))) {
            return condition.apply(game, source);
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        if (creature != null) {
            creature.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
            this.discard();
        }
        return false;
    }

    public VigorMortisReplacementEffect copy() {
        return new VigorMortisReplacementEffect(this);
    }

    public Condition getCondition() {
        return condition;
    }
}

