/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VikyaScorchingStalwartEffect
extends OneShotEffect {
    VikyaScorchingStalwartEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage equal to its power to any target. If excess damage was dealt to a creature this way, draw a card";
    }

    private VikyaScorchingStalwartEffect(VikyaScorchingStalwartEffect effect) {
        super((OneShotEffect)effect);
    }

    public VikyaScorchingStalwartEffect copy() {
        return new VikyaScorchingStalwartEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null) {
            return false;
        }
        int amount = sourcePermanent.getPower().getValue();
        if (amount < 1) {
            return false;
        }
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            Player player2 = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            return player2 != null && player2.damage(amount, source, game) > 0;
        }
        if (!permanent.isCreature(game)) {
            return permanent.damage(amount, source, game) > 0;
        }
        if (permanent.damageWithExcess(amount, source, game) > 0) {
            Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.drawCards(1, source, game));
        }
        return true;
    }
}

