/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnSourceFromGraveyardToBattlefieldEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VincentsLimitBreakEffect
extends OneShotEffect {
    private final int power;
    private final int toughness;

    VincentsLimitBreakEffect(int power, int toughness) {
        super(Outcome.Benefit);
        this.staticText = power + "/" + toughness + '.';
        this.power = power;
        this.toughness = toughness;
    }

    private VincentsLimitBreakEffect(VincentsLimitBreakEffect effect) {
        super((OneShotEffect)effect);
        this.power = effect.power;
        this.toughness = effect.toughness;
    }

    public VincentsLimitBreakEffect copy() {
        return new VincentsLimitBreakEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)new DiesSourceTriggeredAbility((Effect)new ReturnSourceFromGraveyardToBattlefieldEffect(true, true), false)).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        game.addEffect(new SetBasePowerToughnessTargetEffect(this.power, this.toughness, Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

