/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.TriggeredAbility;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class VindictiveVampireTriggeredAbility
extends TriggeredAbilityImpl {
    public VindictiveVampireTriggeredAbility(Zone zone, Effect effect) {
        super(zone, effect, false);
        this.setTriggerPhrase("Whenever another creature you control dies, ");
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private VindictiveVampireTriggeredAbility(VindictiveVampireTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VindictiveVampireTriggeredAbility copy() {
        return new VindictiveVampireTriggeredAbility(this);
    }

    public boolean isInUseableZone(Game game, MageObject sourceObject, GameEvent event) {
        return TriggeredAbilityImpl.isInUseableZoneDiesTrigger((TriggeredAbility)this, (MageObject)sourceObject, (GameEvent)event, (Game)game);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (!zEvent.isDiesEvent() || zEvent.getTarget() == null || game.getPermanentOrLKIBattlefield(this.getSourceId()) == null) {
            return false;
        }
        if (!StaticFilters.FILTER_CONTROLLED_ANOTHER_CREATURE.match(zEvent.getTarget(), this.getControllerId(), (Ability)this, game)) {
            return false;
        }
        for (Effect effect : this.getEffects()) {
            effect.setTargetPointer((TargetPointer)new FixedTarget(event.getTargetId(), game));
        }
        return true;
    }
}

