/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class VirtueOfStrengthReplacementEffect
extends ReplacementEffectImpl {
    VirtueOfStrengthReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you tap a basic land for mana, it produces three times as much of that mana instead";
    }

    private VirtueOfStrengthReplacementEffect(VirtueOfStrengthReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Mana mana = ((ManaEvent)event).getMana();
        if (mana.getBlack() > 0) {
            mana.set(ManaType.BLACK, CardUtil.overflowMultiply((int)mana.getBlack(), (int)3));
        }
        if (mana.getBlue() > 0) {
            mana.set(ManaType.BLUE, CardUtil.overflowMultiply((int)mana.getBlue(), (int)3));
        }
        if (mana.getWhite() > 0) {
            mana.set(ManaType.WHITE, CardUtil.overflowMultiply((int)mana.getWhite(), (int)3));
        }
        if (mana.getGreen() > 0) {
            mana.set(ManaType.GREEN, CardUtil.overflowMultiply((int)mana.getGreen(), (int)3));
        }
        if (mana.getRed() > 0) {
            mana.set(ManaType.RED, CardUtil.overflowMultiply((int)mana.getRed(), (int)3));
        }
        if (mana.getColorless() > 0) {
            mana.set(ManaType.COLORLESS, CardUtil.overflowMultiply((int)mana.getColorless(), (int)3));
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return source.isControlledBy(event.getPlayerId()) && permanent != null && permanent.isBasic(game) && permanent.isLand(game);
    }

    public VirtueOfStrengthReplacementEffect copy() {
        return new VirtueOfStrengthReplacementEffect(this);
    }
}

