/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class VisionsOfPhyrexiaWatcher
extends Watcher {
    private final Set<UUID> playerSet = new HashSet<UUID>();

    VisionsOfPhyrexiaWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case LAND_PLAYED: {
                if (Zone.EXILED.match(event.getZone())) {
                    this.playerSet.add(event.getPlayerId());
                }
                return;
            }
            case SPELL_CAST: {
                Spell spell = game.getSpell(event.getTargetId());
                if (spell == null || !Zone.EXILED.match(spell.getFromZone())) break;
                this.playerSet.add(spell.getControllerId());
            }
        }
    }

    public void reset() {
        super.reset();
        this.playerSet.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((VisionsOfPhyrexiaWatcher)game.getState().getWatcher(VisionsOfPhyrexiaWatcher.class)).playerSet.contains(source.getControllerId());
    }
}

