/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.StaticHint;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class VitoThornOfTheDuskRoseTriggeredAbility
extends TriggeredAbilityImpl {
    VitoThornOfTheDuskRoseTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.addTarget((Target)new TargetOpponent());
    }

    private VitoThornOfTheDuskRoseTriggeredAbility(VitoThornOfTheDuskRoseTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VitoThornOfTheDuskRoseTriggeredAbility copy() {
        return new VitoThornOfTheDuskRoseTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAINED_LIFE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.getControllerId())) {
            MageObject mageObject = game.getObject(event.getSourceId());
            this.getEffects().clear();
            this.getHints().clear();
            this.addHint((Hint)new StaticHint("Lose life amount: " + event.getAmount()));
            if (mageObject != null) {
                this.addHint((Hint)new StaticHint("Caused by: " + mageObject.getLogName()));
            }
            this.addEffect((Effect)new LoseLifeTargetEffect(event.getAmount()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever you gain life, target opponent loses that much life.";
    }
}

