/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.common.search.SearchLibraryPutInPlayEffect;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.common.TargetCardInLibrary;

class VivienMonstersAdvocateTriggeredAbility
extends DelayedTriggeredAbility {
    VivienMonstersAdvocateTriggeredAbility() {
        super(null, Duration.EndOfTurn, true, false);
    }

    private VivienMonstersAdvocateTriggeredAbility(VivienMonstersAdvocateTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        if (spell != null && spell.isCreature(game)) {
            int cmc = spell.getManaValue();
            FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value less than " + cmc);
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, cmc));
            this.getEffects().clear();
            this.getEffects().add((Object)new SearchLibraryPutInPlayEffect(new TargetCardInLibrary((FilterCard)filter)));
            return true;
        }
        return false;
    }

    public VivienMonstersAdvocateTriggeredAbility copy() {
        return new VivienMonstersAdvocateTriggeredAbility(this);
    }

    public String getRule() {
        return "When you next cast a creature spell this turn, search your library for a creature card with lesser mana value, put it onto the battlefield, then shuffle.";
    }
}

