/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ViviensGrizzlyEffect
extends OneShotEffect {
    ViviensGrizzlyEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top card of your library. If it's a creature or planeswalker card, you may reveal it and put it into your hand. If you don't put the card into your hand, put it on the bottom of your library.";
    }

    private ViviensGrizzlyEffect(ViviensGrizzlyEffect effect) {
        super((OneShotEffect)effect);
    }

    public ViviensGrizzlyEffect copy() {
        return new ViviensGrizzlyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        CardsImpl cards = new CardsImpl(card);
        player.lookAtCards(source, null, (Cards)cards, game);
        if (!card.isPlaneswalker(game) && !card.isCreature(game) || !player.chooseUse(this.outcome, "Put this card in your hand?", source, game)) {
            player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        } else {
            player.revealCards(source, (Cards)cards, game);
            player.moveCards(card, Zone.HAND, source, game);
        }
        return true;
    }
}

