/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.v.ViviensInvocationDamageEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponentsCreaturePermanent;
import mage.util.CardUtil;

class ViviensInvocationEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard("creature card to put on the battlefield");

    ViviensInvocationEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Look at the top seven cards of your library. You may put a creature card from among them onto the battlefield. Put the rest on the bottom of your library in a random order. When a creature is put onto the battlefield this way, it deals damage equal to its power to target creature an opponent controls";
    }

    private ViviensInvocationEffect(ViviensInvocationEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 7));
        if (cards.isEmpty()) {
            return true;
        }
        TargetCard target = new TargetCard(Zone.LIBRARY, filter);
        target.withNotTarget(true);
        controller.choose(Outcome.PutCreatureInPlay, (Cards)cards, target, source, game);
        Card card = cards.get(target.getFirstTarget(), game);
        if (card == null) {
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            return true;
        }
        if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
            cards.remove(card);
        }
        if ((permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) == null) {
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
            return true;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ViviensInvocationDamageEffect(new MageObjectReference((MageObject)permanent, game)), false, "it deals damage equals to its power to target creature an opponent controls");
        ability.addTarget((Target)new TargetOpponentsCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    public ViviensInvocationEffect copy() {
        return new ViviensInvocationEffect(this);
    }
}

