/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VizierOfRemediesReplacementEffect
extends ReplacementEffectImpl {
    VizierOfRemediesReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If one or more -1/-1 counters would be put on a creature you control, that many -1/-1 counters minus one are put on it instead";
    }

    private VizierOfRemediesReplacementEffect(VizierOfRemediesReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public VizierOfRemediesReplacementEffect copy() {
        return new VizierOfRemediesReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(event.getAmount() - 1, true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getAmount() <= 0 || !event.getData().equals(CounterType.M1M1.getName())) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null) {
            permanent = game.getPermanentEntering(event.getTargetId());
        }
        return permanent != null && permanent.isControlledBy(source.getControllerId()) && permanent.isCreature(game);
    }
}

