/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class VoidMawEffect
extends ReplacementEffectImpl {
    VoidMawEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If another creature would die, exile it instead";
    }

    private VoidMawEffect(VoidMawEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public VoidMawEffect copy() {
        return new VoidMawEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        UUID exileZoneId;
        Permanent permanent;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        return controller != null && sourceObject != null && ((ZoneChangeEvent)event).getFromZone() == Zone.BATTLEFIELD && (permanent = ((ZoneChangeEvent)event).getTarget()) != null && controller.moveCardsToExile((Card)permanent, source, game, false, exileZoneId = CardUtil.getCardExileZoneId((Game)game, (Ability)source), sourceObject.getIdName());
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getToZone() == Zone.GRAVEYARD && (permanent = ((ZoneChangeEvent)event).getTarget()) != null && !permanent.getId().equals(source.getSourceId()) && (zEvent.getTarget() != null ? zEvent.getTarget().isCreature(game) : permanent.isCreature(game));
    }
}

