/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VoidWinnowerCantBlockEffect
extends RestrictionEffect {
    VoidWinnowerCantBlockEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Your opponents can't block with creatures with even mana values";
    }

    private VoidWinnowerCantBlockEffect(VoidWinnowerCantBlockEffect effect) {
        super((RestrictionEffect)effect);
    }

    public VoidWinnowerCantBlockEffect copy() {
        return new VoidWinnowerCantBlockEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (game.getOpponents(source.getControllerId()).contains(permanent.getControllerId())) {
            return (permanent.getManaValue() & 1) == 0 && permanent.isCreature(game);
        }
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }
}

