/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VolatileRigEffect
extends OneShotEffect {
    VolatileRigEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "flip a coin. If you lose the flip, sacrifice {this}";
    }

    private VolatileRigEffect(VolatileRigEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && !player.flipCoin(source, game, true) && (permanent = game.getPermanent(source.getSourceId())) != null) {
            return permanent.sacrifice(source, game);
        }
        return false;
    }

    public VolatileRigEffect copy() {
        return new VolatileRigEffect(this);
    }
}

