/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VolatileRigEffect2
extends OneShotEffect {
    VolatileRigEffect2() {
        super(Outcome.Sacrifice);
        this.staticText = "flip a coin. If you lose the flip, it deals 4 damage to each creature and each player";
    }

    private VolatileRigEffect2(VolatileRigEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && !player.flipCoin(source, game, true)) {
            List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
            for (Permanent permanent : permanents) {
                permanent.damage(4, source.getSourceId(), source, game, false, true);
            }
            for (UUID playerId : game.getState().getPlayersInRange(player.getId(), game)) {
                Player damageToPlayer = game.getPlayer(playerId);
                if (damageToPlayer == null) continue;
                damageToPlayer.damage(4, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }

    public VolatileRigEffect2 copy() {
        return new VolatileRigEffect2(this);
    }
}

