/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VolcanicEruptionEffect
extends OneShotEffect {
    VolcanicEruptionEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy X target Mountains. {this} deals damage to each creature and each player equal to the number of Mountains put into a graveyard this way.";
    }

    private VolcanicEruptionEffect(VolcanicEruptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public VolcanicEruptionEffect copy() {
        return new VolcanicEruptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int destroyedCount = 0;
        for (UUID targetID : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetID);
            if (permanent == null || !permanent.destroy(source, game, false) || game.getState().getZone(permanent.getId()) != Zone.GRAVEYARD) continue;
            ++destroyedCount;
        }
        if (destroyedCount > 0) {
            List permanents = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
            for (Permanent permanent : permanents) {
                permanent.damage(destroyedCount, source.getSourceId(), source, game, false, true);
            }
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.damage(destroyedCount, source.getSourceId(), source, game);
            }
        }
        return true;
    }
}

