/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.TransformSourceEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class VoldarenBloodcasterTriggeredAbility
extends TriggeredAbilityImpl {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.BLOOD);
    private static final Hint hint;

    VoldarenBloodcasterTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TransformSourceEffect());
        this.addHint(hint);
    }

    private VoldarenBloodcasterTriggeredAbility(VoldarenBloodcasterTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VoldarenBloodcasterTriggeredAbility copy() {
        return new VoldarenBloodcasterTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CREATED_TOKEN;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && filter.match((Object)permanent, game) && this.isControlledBy(event.getPlayerId());
    }

    public boolean checkInterveningIfClause(Game game) {
        return game.getBattlefield().count(filter, this.getControllerId(), (Ability)this, game) >= 5;
    }

    public String getRule() {
        return "Whenever you create a Blood token, if you control five or more Blood tokens, transform {this}.";
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        hint = new ValueHint("Blood tokens you control", (DynamicValue)new PermanentsOnBattlefieldCount(filter));
    }
}

