/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VolrathsShapeshifterEffect
extends ContinuousEffectImpl {
    VolrathsShapeshifterEffect() {
        super(Duration.WhileOnBattlefield, Layer.TextChangingEffects_3, SubLayer.NA, Outcome.BecomeCreature);
        this.staticText = "As long as the top card of your graveyard is a creature card, {this} has the full text of that card and has the text \"2: Discard a card.\" ({this} has that card's name, mana cost, color, types, abilities, power, and toughness.) ";
    }

    private VolrathsShapeshifterEffect(VolrathsShapeshifterEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public VolrathsShapeshifterEffect copy() {
        return new VolrathsShapeshifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getPlayer(source.getControllerId()).getGraveyard().getTopCard(game);
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (card == null || permanent == null || !card.isCreature(game)) {
            return false;
        }
        permanent.getPower().setModifiedBaseValue(card.getPower().getModifiedBaseValue());
        permanent.getToughness().setModifiedBaseValue(card.getToughness().getModifiedBaseValue());
        permanent.getColor(game).setColor(card.getColor(game));
        permanent.getManaCost().clear();
        permanent.getManaCost().add((Object)card.getManaCost().copy());
        permanent.removeAllCardTypes(game);
        permanent.setName(card.getName());
        for (CardType type : card.getCardType(game)) {
            permanent.addCardType(game, new CardType[]{type});
        }
        permanent.removeAllSubTypes(game);
        permanent.copySubTypesFrom(game, (MageObject)card);
        permanent.removeAllSuperTypes(game);
        for (CardType type : card.getSuperType(game)) {
            permanent.addSuperType(game, (SuperType)type);
        }
        for (Ability ability : card.getAbilities(game)) {
            if (permanent.getAbilities().contains(ability)) continue;
            permanent.addAbility(ability, source.getSourceId(), game, true);
        }
        return true;
    }
}

