/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class VoltageSurgeEffect
extends OneShotEffect {
    VoltageSurgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 2 damage to target creature or planeswalker. If this spell's additional cost was paid, {this} deals 4 damage instead";
    }

    private VoltageSurgeEffect(VoltageSurgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public VoltageSurgeEffect copy() {
        return new VoltageSurgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        boolean wasPaid = CardUtil.castStream((Stream)source.getCosts().stream(), SacrificeTargetCost.class).map(SacrificeTargetCost::getPermanents).flatMap(Collection::stream).findFirst().isPresent();
        return permanent.damage(wasPaid ? 4 : 2, source, game) > 0;
    }
}

