/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class VoltaicVisionaryWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> map = new HashMap<UUID, Set<MageObjectReference>>();
    private static final Set<MageObjectReference> emptySet = Collections.unmodifiableSet(new HashSet());

    VoltaicVisionaryWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE || ((ZoneChangeEvent)event).getToZone() != Zone.EXILED || ((ZoneChangeEvent)event).getFromZone() != Zone.LIBRARY) {
            return;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null) {
            return;
        }
        UUID exileId = game.getExile().getExileZones().stream().filter(exileZone -> exileZone.contains((Object)card.getId())).map(ExileZone::getId).findFirst().orElse(null);
        if (exileId == null) {
            return;
        }
        this.map.computeIfAbsent(exileId, x -> new HashSet()).add(new MageObjectReference((MageObject)card, game));
    }

    public void reset() {
        this.map.clear();
        super.reset();
    }

    static boolean checkCard(Card card, Ability source, Game game) {
        return card != null && ((VoltaicVisionaryWatcher)game.getState().getWatcher(VoltaicVisionaryWatcher.class)).map.getOrDefault(CardUtil.getCardExileZoneId((Game)game, (Ability)source), emptySet).contains(new MageObjectReference((MageObject)card, game, -1));
    }
}

