/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.Collection;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.v.VoraciousBibliophileEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;

class VoraciousBibliophileTriggeredAbility
extends TriggeredAbilityImpl {
    public VoraciousBibliophileTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new VoraciousBibliophileEffect(), false);
        this.setTriggerPhrase("Whenever you cast a spell with one or more targets, ");
    }

    private VoraciousBibliophileTriggeredAbility(VoraciousBibliophileTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public VoraciousBibliophileTriggeredAbility copy() {
        return new VoraciousBibliophileTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!event.getPlayerId().equals(this.getControllerId())) {
            return false;
        }
        Spell spell = game.getStack().getSpell(event.getTargetId());
        if (spell == null) {
            return false;
        }
        int numTargets = spell.getStackAbility().getTargets().stream().map(Target::getTargets).mapToInt(Collection::size).sum();
        if (numTargets > 0) {
            this.getEffects().setValue("numTargets", (Object)numTargets);
            return true;
        }
        return false;
    }
}

