/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VorelOfTheHullCladeEffect
extends OneShotEffect {
    VorelOfTheHullCladeEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the number of each kind of counter on target artifact, creature, or land";
    }

    private VorelOfTheHullCladeEffect(VorelOfTheHullCladeEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        for (Counter counter : target.getCounters(game).values()) {
            Counter newCounter = new Counter(counter.getName(), counter.getCount());
            target.addCounters(newCounter, source.getControllerId(), source, game);
        }
        return true;
    }

    public VorelOfTheHullCladeEffect copy() {
        return new VorelOfTheHullCladeEffect(this);
    }
}

