/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.Combat;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;

class VortexElementalEffect
extends OneShotEffect {
    VortexElementalEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put {this} and each creature blocking or blocked by it on top of their owners' libraries, then those players shuffle";
    }

    private VortexElementalEffect(VortexElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public VortexElementalEffect copy() {
        return new VortexElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Combat combat = game.getState().getCombat();
            HashSet<UUID> creaturesToReturn = new HashSet<UUID>();
            HashSet<UUID> playersToShuffle = new HashSet<UUID>();
            creaturesToReturn.add(source.getSourceId());
            if (combat != null) {
                for (CombatGroup combatGroup : combat.getGroups()) {
                    if (combatGroup.getAttackers().contains(source.getSourceId())) {
                        creaturesToReturn.addAll(combatGroup.getBlockers());
                        continue;
                    }
                    if (!combatGroup.getBlockers().contains(source.getSourceId())) continue;
                    creaturesToReturn.addAll(combatGroup.getAttackers());
                }
            }
            for (UUID creatureId : creaturesToReturn) {
                Permanent creature = game.getPermanent(creatureId);
                if (creature == null) continue;
                playersToShuffle.add(creature.getControllerId());
            }
            CardsImpl toLib = new CardsImpl(creaturesToReturn);
            controller.putCardsOnTopOfLibrary((Cards)toLib, game, source, false);
            for (UUID playerId : playersToShuffle) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }
}

