/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.v;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class VulshokBattlemasterEffect
extends OneShotEffect {
    VulshokBattlemasterEffect() {
        super(Outcome.Benefit);
        this.staticText = "attach all Equipment on the battlefield to it";
    }

    private VulshokBattlemasterEffect(VulshokBattlemasterEffect effect) {
        super((OneShotEffect)effect);
    }

    public VulshokBattlemasterEffect copy() {
        return new VulshokBattlemasterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        for (Permanent equipment : game.getBattlefield().getActivePermanents(StaticFilters.FILTER_PERMANENT_EQUIPMENT, source.getControllerId(), source, game)) {
            permanent.addAttachment(equipment.getId(), source, game);
        }
        return true;
    }
}

