/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;

class CardsInOpponentGraveyardsCount
implements DynamicValue {
    private FilterCard filter;

    public CardsInOpponentGraveyardsCount() {
        this(new FilterCard());
    }

    public CardsInOpponentGraveyardsCount(FilterCard filter) {
        this.filter = filter;
    }

    private CardsInOpponentGraveyardsCount(CardsInOpponentGraveyardsCount dynamicValue) {
        this.filter = dynamicValue.filter;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int amount = 0;
        for (UUID playerUUID : game.getOpponents(sourceAbility.getControllerId())) {
            Player player = game.getPlayer(playerUUID);
            if (player == null) continue;
            amount += player.getGraveyard().count(this.filter, sourceAbility.getControllerId(), sourceAbility, game);
        }
        return amount;
    }

    public CardsInOpponentGraveyardsCount copy() {
        return new CardsInOpponentGraveyardsCount(this);
    }

    public String toString() {
        return "1";
    }

    public String getMessage() {
        return this.filter.getMessage();
    }
}

