/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class ExploreTheVastlandsTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("a land card and/or an instant or sorcery card");

    ExploreTheVastlandsTarget() {
        super(0, 2, filter);
    }

    private ExploreTheVastlandsTarget(ExploreTheVastlandsTarget target) {
        super((TargetCardInLibrary)target);
    }

    public ExploreTheVastlandsTarget copy() {
        return new ExploreTheVastlandsTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        boolean isLand = card.isLand(game);
        return this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).noneMatch(c -> card.isLand(game) && c.isLand(game) || card.isInstantOrSorcery(game) && c.isInstantOrSorcery(game));
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.LAND.getPredicate(), CardType.SORCERY.getPredicate(), CardType.INSTANT.getPredicate()}));
    }
}

