/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.w.UntapAttackingThisTurnEffect;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.turn.TurnMod;

class UntapDelayedTriggeredAbility
extends DelayedTriggeredAbility {
    private UUID connectedTurnMod;
    private boolean enabled;

    public UntapDelayedTriggeredAbility() {
        super((Effect)new UntapAttackingThisTurnEffect());
    }

    private UntapDelayedTriggeredAbility(UntapDelayedTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
        this.connectedTurnMod = ability.connectedTurnMod;
        this.enabled = ability.enabled;
    }

    public UntapDelayedTriggeredAbility copy() {
        return new UntapDelayedTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PHASE_CHANGED || event.getType() == GameEvent.EventType.COMBAT_PHASE_PRE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.PHASE_CHANGED && this.connectedTurnMod.equals(event.getSourceId())) {
            this.enabled = true;
            return false;
        }
        if (event.getType() == GameEvent.EventType.COMBAT_PHASE_PRE && this.enabled) {
            game.getState().getTurnMods().add(new TurnMod(this.getControllerId()).withExtraPhase(TurnPhase.POSTCOMBAT_MAIN, TurnPhase.COMBAT));
            this.enabled = false;
            return true;
        }
        return false;
    }

    public void setConnectedTurnMod(UUID connectedTurnMod) {
        this.connectedTurnMod = connectedTurnMod;
    }

    public String getRule() {
        return "At the beginning of that combat, untap all creatures that attacked this turn";
    }
}

