/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.LoseAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WalkingSpongeEffect
extends OneShotEffect {
    WalkingSpongeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target creature loses your choice of flying, first strike, or trample until end of turn";
    }

    private WalkingSpongeEffect(WalkingSpongeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WalkingSpongeEffect copy() {
        return new WalkingSpongeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            ChoiceImpl chooseAbility = new ChoiceImpl(true);
            chooseAbility.setMessage("Choose an ability to remove");
            LinkedHashSet<String> choice = new LinkedHashSet<String>();
            choice.add("Flying");
            choice.add("First strike");
            choice.add("Trample");
            chooseAbility.setChoices(choice);
            FlyingAbility ability = FlyingAbility.getInstance();
            if (controller.choose(Outcome.UnboostCreature, (Choice)chooseAbility, game)) {
                String chosenAbility = chooseAbility.getChoice();
                if (chosenAbility.equals("First strike")) {
                    ability = FirstStrikeAbility.getInstance();
                } else if (chosenAbility.equals("Trample")) {
                    ability = TrampleAbility.getInstance();
                }
            } else {
                return false;
            }
            game.informPlayers(controller.getLogName() + " has chosen " + ability.getRule());
            LoseAbilityTargetEffect effect = new LoseAbilityTargetEffect((Ability)ability, Duration.EndOfTurn);
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

