/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.BlocksCreatureTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.BandingAbility;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class WallOfCaltropsAbility
extends BlocksCreatureTriggeredAbility {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Wall creature");

    public WallOfCaltropsAbility() {
        super((Effect)new GainAbilitySourceEffect((Ability)BandingAbility.getInstance(), Duration.EndOfTurn));
    }

    private WallOfCaltropsAbility(WallOfCaltropsAbility ability) {
        super((BlocksCreatureTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        CombatGroup group;
        Permanent targetPermanent;
        if (event.getSourceId().equals(this.getSourceId()) && (targetPermanent = game.getPermanent(event.getTargetId())) != null && targetPermanent.isCreature(game) && (group = game.getCombat().findGroup(targetPermanent.getId())) != null) {
            for (UUID blockerId : group.getBlockers()) {
                Permanent blocker = game.getPermanent(blockerId);
                if (blocker == null || filter.match((Object)blocker, game)) continue;
                return false;
            }
            return group.getBlockers().size() > 1 && group.getBlockers().contains(this.sourceId);
        }
        return false;
    }

    public boolean checkInterveningIfClause(Game game) {
        return true;
    }

    public String getRule() {
        return "Whenever {this} blocks a creature, if at least one other Wall creature is blocking that creature and no non-Wall creatures are blocking that creature, {this} gains banding until end of turn.";
    }

    public WallOfCaltropsAbility copy() {
        return new WallOfCaltropsAbility(this);
    }

    static {
        filter.add((Predicate)SubType.WALL.getPredicate());
    }
}

