/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.TurnPhase;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WallOfDustRestrictionEffect
extends RestrictionEffect {
    protected MageObjectReference targetPermanentReference;

    public WallOfDustRestrictionEffect() {
        super(Duration.Custom);
        this.staticText = "that creature can't attack during its controller's next turn";
    }

    private WallOfDustRestrictionEffect(WallOfDustRestrictionEffect effect) {
        super((RestrictionEffect)effect);
        this.targetPermanentReference = effect.targetPermanentReference;
    }

    public WallOfDustRestrictionEffect copy() {
        return new WallOfDustRestrictionEffect(this);
    }

    public boolean isInactive(Ability source, Game game) {
        if (this.targetPermanentReference == null || this.targetPermanentReference.getPermanent(game) == null) {
            return true;
        }
        return game.getTurnPhaseType() == TurnPhase.END && this.isYourNextTurn(game);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Permanent perm = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (perm != null) {
            this.targetPermanentReference = new MageObjectReference((MageObject)perm, game);
            this.setStartingControllerAndTurnNum(game, perm.getControllerId(), game.getActivePlayerId());
        } else {
            this.discard();
        }
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(this.getTargetPointer().getFirst(game, source))) {
            return game.isActivePlayer(permanent.getControllerId());
        }
        return false;
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }
}

