/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WandOfIthEffect
extends OneShotEffect {
    WandOfIthEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals a card at random from their hand. If it's a land card, that player discards it unless they pay 1 life. If it isn't a land card, the player discards it unless they pay life equal to its mana value";
    }

    private WandOfIthEffect(WandOfIthEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (player != null && !player.getHand().isEmpty()) {
            CardsImpl revealed = new CardsImpl();
            Card card = player.getHand().getRandom(game);
            if (card != null) {
                revealed.add(card);
                player.revealCards(sourcePermanent.getName(), (Cards)revealed, game);
                int lifeToPay = card.isLand(game) ? 1 : card.getManaValue();
                PayLifeCost cost = new PayLifeCost(lifeToPay);
                if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(this.outcome, "Pay " + lifeToPay + " life to prevent discarding " + card.getLogName() + "?", source, game) && cost.pay(source, game, source, player.getId(), false, null)) {
                    game.informPlayers(player.getLogName() + " has paid " + lifeToPay + " life to prevent discarding " + card.getLogName() + " (" + sourcePermanent.getLogName() + ')');
                } else {
                    player.discard(card, false, source, game);
                }
            }
            return true;
        }
        return false;
    }

    public WandOfIthEffect copy() {
        return new WandOfIthEffect(this);
    }
}

