/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.ManaUtil;

class WanderingArchaicEffect
extends OneShotEffect {
    WanderingArchaicEffect() {
        super(Outcome.Benefit);
        this.staticText = "they may pay {2}. If they don't, you may copy that spell. You may choose new targets for the copy";
    }

    private WanderingArchaicEffect(WanderingArchaicEffect effect) {
        super((OneShotEffect)effect);
    }

    public WanderingArchaicEffect copy() {
        return new WanderingArchaicEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Spell spell = (Spell)this.getValue("spellCast");
        if (controller == null || opponent == null || spell == null) {
            return false;
        }
        ManaCost cost = ManaUtil.createManaCost((int)2, (boolean)false);
        if (cost.canPay(source, source, opponent.getId(), game) && opponent.chooseUse(this.outcome, "Pay {2}?", source, game) && cost.pay(source, game, source, opponent.getId(), false)) {
            return true;
        }
        if (controller.chooseUse(this.outcome, "Copy " + spell.getName() + "?", source, game)) {
            spell.createCopyOnStack(game, source, controller.getId(), true);
        }
        return true;
    }
}

