/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.constants.CommanderCardType;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.players.Player;

enum WarRoomValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller == null) {
            return 0;
        }
        ObjectColor color = new ObjectColor();
        boolean hasCommander = false;
        for (UUID commanderId : game.getCommandersIds(controller, CommanderCardType.COMMANDER_OR_OATHBREAKER, false)) {
            Card commander = game.getCard(commanderId);
            if (commander == null) continue;
            FilterMana commanderMana = commander.getColorIdentity();
            if (commanderMana.isWhite()) {
                color.setWhite(true);
            }
            if (commanderMana.isBlue()) {
                color.setBlue(true);
            }
            if (commanderMana.isBlack()) {
                color.setBlack(true);
            }
            if (commanderMana.isRed()) {
                color.setRed(true);
            }
            if (commanderMana.isGreen()) {
                color.setGreen(true);
            }
            hasCommander = true;
        }
        return hasCommander ? color.getColorCount() : Integer.MAX_VALUE;
    }

    public WarRoomValue copy() {
        return instance;
    }

    public String getMessage() {
        return "";
    }
}

