/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class WarTrainedSlasherEffect
extends OneShotEffect {
    WarTrainedSlasherEffect() {
        super(Outcome.Benefit);
    }

    private WarTrainedSlasherEffect(WarTrainedSlasherEffect effect) {
        super((OneShotEffect)effect);
    }

    public WarTrainedSlasherEffect copy() {
        return new WarTrainedSlasherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        if (power == 0) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostSourceEffect(power, 0, Duration.EndOfTurn), source);
        return true;
    }
}

