/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.common.DashedCondition;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.abilities.keyword.DashAbility;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class WarbringerSpellsCostReductionEffect
extends CostModificationEffectImpl {
    WarbringerSpellsCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Dash costs you pay cost {2} less <i>(as long as this creature is on the battlefield)</i>";
    }

    protected WarbringerSpellsCostReductionEffect(WarbringerSpellsCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)2);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (!(abilityToModify instanceof SpellAbility)) return false;
        if (!abilityToModify.isControlledBy(source.getControllerId())) {
            return false;
        }
        if (game == null) return DashedCondition.instance.apply(game, abilityToModify);
        if (!game.inCheckPlayableState()) {
            return DashedCondition.instance.apply(game, abilityToModify);
        }
        Card card = game.getCard(source.getSourceId());
        if (card == null) return false;
        if (!card.getAbilities(game).stream().anyMatch(DashAbility.class::isInstance)) return false;
        return true;
    }

    public WarbringerSpellsCostReductionEffect copy() {
        return new WarbringerSpellsCostReductionEffect(this);
    }
}

