/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.PlayerLostLifeWatcher;

class WarlockClassEffect
extends OneShotEffect {
    WarlockClassEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent loses life equal to the life they lost this turn.";
    }

    private WarlockClassEffect(WarlockClassEffect effect) {
        super((OneShotEffect)effect);
    }

    public WarlockClassEffect copy() {
        return new WarlockClassEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        if (watcher == null) {
            return false;
        }
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            int lifeLost;
            Player opponent = game.getPlayer(playerId);
            if (opponent == null || (lifeLost = watcher.getLifeLost(playerId)) <= 0) continue;
            opponent.loseLife(lifeLost, game, source, false);
        }
        return true;
    }
}

