/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.TrainingAbility;
import mage.abilities.triggers.BeginningOfEndStepTriggeredAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.AttackedThisTurnPredicate;

public final class WarriorsResolve
extends CardImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent("you control a creature with a +1/+1 counter on it that attacked this turn");
    private static final Condition condition;

    public WarriorsResolve(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityControlledEffect((Ability)new TrainingAbility(), Duration.WhileControlled, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES)));
        this.addAbility((Ability)new BeginningOfEndStepTriggeredAbility((Effect)new DrawCardSourceControllerEffect(1)).withInterveningIf(condition));
    }

    private WarriorsResolve(WarriorsResolve card) {
        super((CardImpl)card);
    }

    public WarriorsResolve copy() {
        return new WarriorsResolve(this);
    }

    static {
        filter.add((Predicate)CounterType.P1P1.getPredicate());
        filter.add((Predicate)AttackedThisTurnPredicate.instance);
        condition = new PermanentsOnTheBattlefieldCondition(filter);
    }
}

