/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WarstormSurgeEffect
extends OneShotEffect {
    WarstormSurgeEffect() {
        super(Outcome.Damage);
        this.staticText = "it deals damage equal to its power to any target";
    }

    private WarstormSurgeEffect(WarstormSurgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public WarstormSurgeEffect copy() {
        return new WarstormSurgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID creatureId = (UUID)this.getValue("damageSource");
        Permanent creature = game.getPermanentOrLKIBattlefield(creatureId);
        if (creature != null) {
            int amount = creature.getPower().getValue();
            UUID target = source.getTargets().getFirstTarget();
            Permanent targetCreature = game.getPermanent(target);
            if (targetCreature != null) {
                targetCreature.damage(amount, creature.getId(), source, game, false, true);
                return true;
            }
            Player player = game.getPlayer(target);
            if (player != null) {
                player.damage(amount, creature.getId(), source, game);
                return true;
            }
        }
        return false;
    }
}

