/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WasitoraCatDragonToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class WasitoraNekoruQueenEffect
extends OneShotEffect {
    WasitoraNekoruQueenEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player sacrifices a creature. If the player can't, you create a 3/3 black, red, and green Cat Dragon creature token with flying";
    }

    private WasitoraNekoruQueenEffect(WasitoraNekoruQueenEffect effect) {
        super((OneShotEffect)effect);
    }

    public WasitoraNekoruQueenEffect copy() {
        return new WasitoraNekoruQueenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (damagedPlayer != null && controller != null) {
            Permanent objectToBeSacrificed;
            TargetSacrifice target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
            if (damagedPlayer.choose(Outcome.Sacrifice, (Target)target, source, game) && (objectToBeSacrificed = game.getPermanent(target.getFirstTarget())) != null && objectToBeSacrificed.sacrifice(source, game)) {
                return true;
            }
            new CreateTokenEffect((Token)new WasitoraCatDragonToken()).apply(game, source);
            return true;
        }
        return false;
    }
}

