/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.decorator.ConditionalRestrictionEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.combat.CantBeBlockedAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class WayOfTheThief
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("Gate");
    private static final String rule = "Enchanted creature can't be blocked as long as you control a Gate";

    public WayOfTheThief(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{3}{U}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 2, Duration.WhileOnBattlefield)));
        ConditionalRestrictionEffect effect = new ConditionalRestrictionEffect((RestrictionEffect)new CantBeBlockedAttachedEffect(AttachmentType.AURA), (Condition)new PermanentsOnTheBattlefieldCondition(filter));
        effect.setText(rule);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)effect));
    }

    private WayOfTheThief(WayOfTheThief card) {
        super((CardImpl)card);
    }

    public WayOfTheThief copy() {
        return new WayOfTheThief(this);
    }

    static {
        filter.add((Predicate)SubType.GATE.getPredicate());
    }
}

