/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextCleanupDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.WaylayToken;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class WaylayEffect
extends OneShotEffect {
    WaylayEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create three 2/2 white Knight creature tokens. Exile them at the beginning of the next cleanup step.";
    }

    private WaylayEffect(WaylayEffect effect) {
        super((OneShotEffect)effect);
    }

    public WaylayEffect copy() {
        return new WaylayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        WaylayToken token = new WaylayToken();
        token.putOntoBattlefield(3, game, source, source.getControllerId());
        ArrayList<Permanent> toExile = new ArrayList<Permanent>();
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent tokenPermanent = game.getPermanent(tokenId);
            if (tokenPermanent == null) continue;
            toExile.add(tokenPermanent);
        }
        ExileTargetEffect effect = new ExileTargetEffect();
        effect.setTargetPointer((TargetPointer)new FixedTargets(toExile, game));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextCleanupDelayedTriggeredAbility((Effect)effect), source);
        return true;
    }
}

