/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.BatchTriggeredAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.permanent.Permanent;

class WaytaTrainerProdigyEffect
extends ReplacementEffectImpl {
    WaytaTrainerProdigyEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature you control being dealt damage causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time";
    }

    private WaytaTrainerProdigyEffect(WaytaTrainerProdigyEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public WaytaTrainerProdigyEffect copy() {
        return new WaytaTrainerProdigyEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent triggeringPermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        if (triggeringPermanent == null || !triggeringPermanent.isControlledBy(source.getControllerId())) {
            return false;
        }
        GameEvent sourceEvent = ((NumberOfTriggersEvent)event).getSourceEvent();
        if (sourceEvent instanceof DamagedEvent) {
            return WaytaTrainerProdigyEffect.checkDamagedEvent((DamagedEvent)sourceEvent, source.getControllerId(), game);
        }
        if (sourceEvent instanceof BatchEvent) {
            TriggeredAbility sourceTrigger = ((NumberOfTriggersEvent)event).getSourceTrigger();
            for (Object o : sourceTrigger instanceof BatchTriggeredAbility ? ((BatchTriggeredAbility)sourceTrigger).getFilteredEvents((BatchEvent)sourceEvent, game) : ((BatchEvent)sourceEvent).getEvents()) {
                if (!(o instanceof DamagedEvent) || !WaytaTrainerProdigyEffect.checkDamagedEvent((DamagedEvent)o, source.getControllerId(), game)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkDamagedEvent(DamagedEvent event, UUID controllerId, Game game) {
        Permanent damagedPermanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return damagedPermanent != null && damagedPermanent.isCreature(game) && damagedPermanent.isControlledBy(controllerId);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

