/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamagePermanentEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WeepingAngelDamageEffect
extends PreventionEffectImpl {
    WeepingAngelDamageEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, true, false);
        this.staticText = "If {this} would deal combat damage to a creature, prevent that damage and that creature's owner shuffles it into their library.";
    }

    private WeepingAngelDamageEffect(WeepingAngelDamageEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public WeepingAngelDamageEffect copy() {
        return new WeepingAngelDamageEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        game.preventDamage(event, source, game, Integer.MAX_VALUE);
        Permanent card = game.getPermanent(event.getTargetId());
        if (card == null) {
            return false;
        }
        Player owner = game.getPlayer(card.getOwnerId());
        if (owner != null) {
            owner.shuffleCardsToLibrary((Card)card, game, source);
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        return event.getSourceId().equals(source.getSourceId()) && ((DamagePermanentEvent)event).isCombatDamage();
    }
}

