/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.w;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class WeightOfSpiresEffect
extends OneShotEffect {
    WeightOfSpiresEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage to target creature equal to the number of nonbasic lands that creature's controller controls";
    }

    private WeightOfSpiresEffect(WeightOfSpiresEffect effect) {
        super((OneShotEffect)effect);
    }

    public WeightOfSpiresEffect copy() {
        return new WeightOfSpiresEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        Player player = game.getPlayer(creature.getControllerId());
        if (player == null) {
            return false;
        }
        int damage = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_LANDS_NONBASIC, player.getId(), game).size();
        return new DamageTargetEffect(damage).apply(game, source);
    }
}

